﻿using UnityEngine;
using System.Collections;
using System.Collections.Generic;
using MadLevelManager;
using System.Linq;

public class AvatarsExample : MonoBehaviour {

    // ===========================================================
    // Constants
    // ===========================================================

    // ===========================================================
    // Fields
    // ===========================================================
    
    // avatar array
    public Texture2D[] avatars;
    // position modifier for avatar stacking
    public Vector3 stackingModifier = new Vector3(12, -12);
    
    // depth counter
    int depth = 100;
    // stacking counter
    Dictionary<MadLevelIcon, int> stackCounter = new Dictionary<MadLevelIcon, int>();

    // ===========================================================
    // Methods for/from SuperClass/Interfaces
    // ===========================================================

    // ===========================================================
    // Methods
    // ===========================================================

    void Start() {
    	if (avatars != null) {
    		foreach (var avatar in avatars) {
    			var icon = RandomIcon();
    			AddAvatar(avatar, icon);
    		}
    	}
    }

	// gets the random displayed icon
	MadLevelIcon RandomIcon() {
		var layout = MadLevelLayout.current;
		var levels = (from l in MadLevel.activeConfiguration.levels where l.type == MadLevel.Type.Level select l).ToArray();
		
		var randomLevelName = levels[Random.Range(0, levels.Length)].name;
		var randomIcon = layout.GetIcon(randomLevelName);
		
		return randomIcon;
	}

	// adds avatar to icon
    void AddAvatar(Texture2D avatarTexture, MadLevelIcon levelIcon) {
    	var draggable = GetDraggable();
    	
    	// creates avatar sprite under the draggable
		var sprite = MadTransform.CreateChild<MadSprite>(
			draggable.transform, "avatar " + avatarTexture.name);
			
    	sprite.texture = avatarTexture;
    	sprite.guiDepth = depth++;
    	
    	sprite.transform.localPosition = GetAvatarLocalPosition(levelIcon);
    }

    // gets the local position for avatar    
    Vector3 GetAvatarLocalPosition(MadLevelIcon icon) {
    	var bounds = icon.GetBounds();
    	var localPosition =
    		icon.transform.localPosition
    		+ new Vector3(bounds.width / 2, -bounds.height / 2, 0)
    		+ GetStackModifier(icon);
    	return localPosition;
    }
    
    // gets the stack modifier. If there will be more than one avatar over an icon,
    // it will be moved by the stacking modifier
    Vector3 GetStackModifier(MadLevelIcon icon) {
    	int multiplier = 0;
    
    	if (stackCounter.ContainsKey(icon)) {
    		multiplier = stackCounter[icon];
    	}
    	
		stackCounter[icon] = multiplier + 1;
		
		return stackingModifier * multiplier;
    }
    
    MadDraggable GetDraggable() {
		var layout = MadLevelLayout.current;
		var draggable = MadTransform.FindChild<MadDraggable>(layout.transform);
		
		if (draggable == null) {
			Debug.LogError("Cannot find draggable for current layout");
			return null;
		}
		
		return draggable;
    }

    // ===========================================================
    // Static Methods
    // ===========================================================

    // ===========================================================
    // Inner and Anonymous Classes
    // ===========================================================

}